//
//  GSGuide.h
//  GlyphsCore
//
//  Created by Georg Seifert on 03.02.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSElement.h>
#import <GlyphsCore/GSUserDataProtocol.h>

@class GSHandle;
@class GSLayer;

typedef NS_ENUM(uint8_t, GSGuideType) {
	GSGuideTypeLine = 0,
	GSGuideTypeCircle,
	GSGuideTypeRect,
};
/**
 The Guide object
 */
@interface GSGuide : GSElement <GSUserDataProtocol> {
	CGFloat _angle;
	BOOL _lockAngle;
	GSHandle *_handle;
	BOOL _showMeasurement;
	NSArray *_intersections;
	NSString *_name;
	CGFloat _length;
	CGFloat _grid;
	NSSize _size;
	NSPredicate *_filter;
	NSMutableDictionary *_userData;
	GSGuideType _type;
}

/** the Angle */
@property (nonatomic) CGFloat angle;
@property (nonatomic) BOOL lockAngle;
/** Alignment
 GSAlignmentLeft,
 GSAlignmentRight,
 */
@property (nonatomic, strong) GSHandle *handle;
/// if active, the guides shows the distances between the intersection with the outline
@property (nonatomic, assign) BOOL showMeasurement;
/// the intersections with the outline
@property (nonatomic, strong) NSArray *intersections;
/// the name of the guide
@property (nonatomic, retain) NSString *name;
/// a filter that allows to show the guide only in certain glyphs
@property (nonatomic, retain) NSPredicate *filter;
@property (nonatomic, assign) CGFloat grid;
@property (nonatomic, assign) CGFloat length;

@property (nonatomic, assign) NSSize size;
@property (nonatomic, assign) GSGuideType type;
@property (nonatomic, assign) NSString *typeString;

- (BOOL)isEqualToGuide:(GSGuide *)other;

/// update the intersections list
- (void)calculateIntersectionsForLayer:(GSLayer *)layer;

- (BOOL)visibleInGlyph:(GSGlyph *)glyph;

/// check if the aPoint is close enough to the guide
- (BOOL)hitTest:(NSPoint)aPoint inLayer:(GSLayer *)layer tolerance:(CGFloat)tolerance;

- (NSPoint)beginPointForLayerWidth:(CGFloat)width;

- (NSPoint)endPointForLayerWidth:(CGFloat)width;

@end
